<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Helpers\BaseEntityService;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Entities\NavigationGroup;

/**
 * Class NavigationsGroups
 * @package Navigations\Model
 *
 * @method NavigationGroup|object|null getReference($id)
 * @method NavigationGroup[]|null getAll()
 * @method NavigationGroup|null get($id)
 */
class NavigationsGroups extends BaseEntityService
{
	protected $entityClass = NavigationGroup::class;

	/**
	 * @return null|NavigationGroup[]
	 */
	public function getAll() { return $this->getEr()->findAll(); }

	/**
	 * @param $id
	 *
	 * @return null|object|NavigationGroup
	 */
	public function find($id)
	{
		return $this->getEr()->find($id);
	}

	/**
	 * @param $id
	 *
	 * @return \Doctrine\ORM\Proxy\Proxy
	 */
	public function getReference($id)
	{
		return $this->getEr()->getReference($id);
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function removeNavigationGroup($id)
	{
		if ($navG = $this->get($id)) {
			$navs = $this->em->getRepository(Navigation::class)->findBy(['group' => $id]);

			if (count($navs) > 1)
				return 'navigations.navigationGroup.removeFailedHasNavs';
			else if (count($navs) == 1)
				$this->em->remove($navs);

			$this->em->remove($navG);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
