<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\Route;
use Core\Model\Router\RouteList;

class RouterFrontFactory
{
	/** @var Navigations */
	protected $navigationsService;

	/** @var RouteHelper */
	protected $routerHelper;

	public function __construct(Navigations $navigations, RouteHelper $routeHelper)
	{
		$this->routerHelper       = $routeHelper;
		$this->navigationsService = $navigations;
	}

	public function createRouter()
	{
		$router = new RouteList;

		$router[] = $this->routerHelper->createRoute('/<path .*>', [
			null => [
				Route::FILTER_IN  => function($params) {
					if (!isset($params['path'])) {
						return null;
					}

					$in = $this->navigationsService->getIdByUrl($params);

					if ($in) {
						if (is_array($params))
							$params = $params + $in;
						unset($params['path']);

						return $params;
					}

					return null;
				},
				Route::FILTER_OUT => function($params) {
					$out = $this->navigationsService->getUrlById($params);

					if ($out) {
						$params['path'] = ltrim($out, '/');
					} else {
						return null;
					}

					unset($params['id']);
					unset($params['locale']);
					unset($params['action']);
					unset($params['presenter']);
					unset($params['activeNavigation']);

					return $params;
				},
			],
		]);

		$router[] = $this->routerHelper->createRoute('/', [
			null => [
				Route::FILTER_IN  => function($params) {
					unset($params['activeNavigation']);
					unset($params['id']);
					$hp = $this->navigationsService->getHomepage($params['locale'] ?? null);

					if ($hp)
						return $params + $hp;
					else
						return $params;
				},
				Route::FILTER_OUT => function($params) {
					unset($params['action']);
					unset($params['presenter']);
					unset($params['activeNavigation']);

					return $params;
				},
			],
		]);

		return $router;
	}
}
