<?php declare(strict_types = 1);

namespace Navigations\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Navigations\Model\Navigations;

class CurrentNavigation extends TemplateTextType implements ITemplateTextType
{

	protected $type = 'navByGroup';

	/** @var Navigations */
	protected $navigationsService;

	public function __construct(Navigations $navigations)
	{
		$this->navigationsService = $navigations;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$groups = ['' => ''];
		foreach ($this->navigationsService->getEr()->findBy([], ['title' => 'ASC']) as $g) {
			$groups[$g->getId()] = $g->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $groups);
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->navigationsService->getNavigation((int) $this->getDefault());
	}
}
