<?php declare(strict_types = 1);

namespace Navigations\Model;

use Contributte\EventDispatcher\EventDispatcher;
use Core\Model\Helpers\Traits\TranslatorTrait;
use Core\Model\Lang\Translator;
use Nette\Localization\ITranslator;

abstract class BaseItem
{
	protected $id;
	protected $title;
	protected $langBase;
	protected $presenter;
	protected $action;

	/** @var ITranslator @inject */
	public $translator;

	/** @var EventDispatcher @inject */
	public $eventDispatcher;

	protected function t($message, $count = null, $parameters = [], $domain = null, $locale = null)
	{
		return $this->translator->translate($message, $count, $parameters, $domain, $locale);
	}

	public function getGroup()
	{
		return explode('\\', get_called_class())[0];
	}

	public function getGroupTitle()
	{
		return $this->langBase . '.groupTitle';
	}

	public function getTitle()
	{
		return $this->langBase . '.' . $this->title;
	}

	public function getClassString()
	{
		return get_called_class();
	}

	public function setId($id)
	{
		$this->id = $id;
	}

	public function getId() { return $this->id; }

	public function setTranslator($translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @param array $cache
	 * @param array $urlParams
	 */
	public function updateCacheDep(array &$cache, $urlParams) { }

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function getPresenter() { return $this->presenter; }

	public function getAction() { return $this->action; }

	public function getComponentChild(string $lang, $navigation = null, $siteMapData = false) { return []; }
}
