<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Model;

use Core\Model\Exceptions\EntityContainChildren;
use Core\Model\Helpers\BaseEntityService;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Entities\NavigationGroup;

/**
 * Class NavigationsGroups
 * @package Navigations\AdminModule\Model
 *
 * @method NavigationGroup|object|null getReference($id)
 * @method NavigationGroup|null get($id)
 */
class NavigationsGroups extends BaseEntityService
{
	/** @var string */
	protected $entityClass = NavigationGroup::class;

	public function getAll()
	{
		return $this->getEr()->createQueryBuilder('g')->addSelect('gt')
			->join('g.texts', 'gt')
			->getQuery()->getResult();
	}

	public function remove($id)
	{
		$group = $this->get($id);

		if ($group) {
			$navs = $this->em->getRepository(Navigation::class)->findBy(['group' => $id]);

			if (count($navs) > 1)
				throw new EntityContainChildren('navigations.navigationGroup.removeFailedHasNavs');
			else if (count($navs) === 1)
				$this->em->remove($navs);

			$this->em->remove($group);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
