<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Model;

use Contributte\Translation\Translator;
use Core\Model\Exceptions\EntityContainChildren;
use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Query\Expr\Join;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Entities\NavigationGroup;

/**
 * @method NavigationGroup getReference($id)
 * @method NavigationGroup|null get($id)
 */
class NavigationsGroups extends BaseEntityService
{
	/** @var string */
	protected $entityClass = NavigationGroup::class;

	protected ?array $cOptionsForSelect = null;

	public function __construct(
		protected Translator $translator,
	)
	{
	}

	/**
	 * @return NavigationGroup[]
	 */
	public function getAll(): array
	{
		return $this->getEr()->createQueryBuilder('g')->addSelect('gt')
			->join('g.texts', 'gt')
			->getQuery()->getResult();
	}

	/**
	 * @param int|string $id
	 *
	 * @throws EntityContainChildren
	 */
	public function remove($id): bool
	{
		$group = $this->get($id);

		if ($group) {
			$navs = $this->em->getRepository(Navigation::class)->findBy(['group' => $id]);

			if (count($navs) > 1) {
				throw new EntityContainChildren('navigations.navigationGroup.removeFailedHasNavs');
			}

			if (count($navs) === 1) {
				$this->em->remove($navs[0]);
			}

			$this->em->remove($group);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getOptionsForSelect(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];

			foreach ($this->getEr()->createQueryBuilder('g')
				         ->select('g.id, gt.title')
				         ->innerJoin('g.texts', 'gt', Join::WITH, 'gt.lang = :lang')
				         ->setParameter('lang', $this->translator->getLocale())
				         ->orderBy('gt.title')
				         ->getQuery()->getResult() as $v) {
				$this->cOptionsForSelect[$v['id']] = $v['title'];
			}
		}

		return $this->cOptionsForSelect ?: [];
	}
}
