<?php declare(strict_types = 1);

namespace Navigations\DI;

use Nette\PhpGenerator\ClassType;
use Nette\DI\Definitions\ServiceDefinition;
use Core\DI\CompilerExtension;
use Navigations\Model\Providers\INavigationItem;
use Nette;

class NavigationsExtension extends CompilerExtension
{
	/** @var string[] */
	protected array $navigationItems = [];

	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Navigations' => 'Navigations\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var ServiceDefinition $service */
        $service = $builder->getDefinition('navigations.itemsCollector');
		$service->addSetup('loadClasses', [$builder->findByType(INavigationItem::class)]);

		foreach ($builder->findByType(INavigationItem::class) as $k => $service) {
			$this->navigationItems[] = $k;
		}
	}

	public function afterCompile(ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('if (php_sapi_name() !== \'cli\') {');
		$init->addBody('$translatorService = $this->getService(\'translation.translator\');');
		$init->addBody('$this->getService(\'navigations.navigations\')->translator = $translatorService;');

		foreach ($this->navigationItems as $item) {
			$init->addBody('$this->getService(\'' . $item . '\')->setTranslator($translatorService);');
		}
		$init->addBody('}');

		$init->addBody('Navigations\Model\NavigationConfig::setParams($this->parameters[\'navigations\']);');
	}

}
