<?php declare(strict_types = 1);

namespace Navigations\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010105 extends AbstractMigration
{
	public function up(Schema $schema): void
	{

		$this->addSql(
			'CREATE TABLE navigations__navigation (id INT AUTO_INCREMENT NOT NULL, group_id INT NOT NULL, parent_id INT DEFAULT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, meta_description VARCHAR(255) DEFAULT NULL, is_published SMALLINT NOT NULL, is_homepage SMALLINT DEFAULT 0 NOT NULL, link VARCHAR(255) NOT NULL, type VARCHAR(255) NOT NULL, content_params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', attribs LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', background VARCHAR(255) DEFAULT NULL, position INT NOT NULL, lang VARCHAR(2) DEFAULT NULL, INDEX IDX_493AC53FFE54D947 (group_id), INDEX IDX_493AC53F727ACA70 (parent_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE navigations__navigation_group (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL, type VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);

		$this->addSql(
			'ALTER TABLE navigations__navigation ADD CONSTRAINT FK_493AC53FFE54D947 FOREIGN KEY (group_id) REFERENCES navigations__navigation_group (id) ON DELETE RESTRICT',
		);
		$this->addSql(
			'ALTER TABLE navigations__navigation ADD CONSTRAINT FK_493AC53F727ACA70 FOREIGN KEY (parent_id) REFERENCES navigations__navigation (id) ON DELETE CASCADE',
		);
	}

	public function down(Schema $schema): void
	{

		$this->addSql('ALTER TABLE navigations__navigation DROP FOREIGN KEY FK_493AC53F727ACA70');
		$this->addSql('ALTER TABLE navigations__navigation DROP FOREIGN KEY FK_493AC53FFE54D947');
		$this->addSql('DROP TABLE navigations__navigation');
		$this->addSql('DROP TABLE navigations__navigation_group');
	}
}
