<?php declare(strict_types = 1);

namespace Navigations\Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

final class Version20190820155800 extends AbstractMigration
{
	protected static array $navigations = [];

	protected static array $groups = [];

	public function up(Schema $schema): void
	{

		self::$navigations = $this->connection->fetchAllAssociative("SELECT * FROM navigations__navigation");
		self::$groups      = $this->connection->fetchAllAssociative("SELECT * FROM navigations__navigation_group");

		$this->addSql(
			'CREATE TABLE navigations__navigation_group_text (lang VARCHAR(2) NOT NULL, group_id INT NOT NULL, title VARCHAR(255) NOT NULL, INDEX IDX_61917BBFE54D947 (group_id), PRIMARY KEY(group_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'CREATE TABLE navigations__navigation_text (lang VARCHAR(2) NOT NULL, navigation_id INT NOT NULL, title VARCHAR(255) NOT NULL, alias VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, is_homepage SMALLINT DEFAULT 0 NOT NULL, params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', seo LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_7AD7063A39F79D6D (navigation_id), PRIMARY KEY(navigation_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB',
		);
		$this->addSql(
			'ALTER TABLE navigations__navigation_group_text ADD CONSTRAINT FK_61917BBFE54D947 FOREIGN KEY (group_id) REFERENCES navigations__navigation_group (id) ON DELETE CASCADE',
		);
		$this->addSql(
			'ALTER TABLE navigations__navigation_text ADD CONSTRAINT FK_7AD7063A39F79D6D FOREIGN KEY (navigation_id) REFERENCES navigations__navigation (id) ON DELETE CASCADE',
		);
		$this->addSql('DROP INDEX lang_idx ON navigations__navigation');
		$this->addSql(
			'ALTER TABLE navigations__navigation ADD component_params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', ADD created DATETIME DEFAULT NULL, DROP title, DROP alias, DROP is_published, DROP is_homepage, DROP content_params, DROP background, DROP position, DROP lang, DROP image, DROP seo',
		);
		$this->addSql('ALTER TABLE navigations__navigation_group DROP title');
	}

	public function postUp(Schema $schema): void
	{
		parent::postUp($schema);

		$configFile = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		if (!$configFile) {
			return;
		}

		$appConfig   = Neon::decode($configFile);
		$defaultLang = $appConfig['parameters']['translation']['default'] ?? 'cs';

		foreach (self::$groups as $v) {
			$this->connection->insert('navigations__navigation_group_text', [
				'group_id' => $v['id'],
				'title'    => $v['title'],
				'lang'     => $defaultLang,
			]);
		}

		foreach (self::$navigations as $v) {
			$this->connection->insert('navigations__navigation_text', [
				'navigation_id' => $v['id'],
				'lang'          => $v['lang'] && $v['lang'] != '' ? $v['lang'] : $defaultLang,
				'title'         => $v['title'],
				'alias'         => $v['alias'],
				'seo'           => $v['seo'],
				'is_homepage'   => $v['is_homepage'] ?: 0,
				'is_published'  => $v['is_published'] ?: 1,
			]);

			$this->connection->update('navigations__navigation', [
				'component_params' => $v['content_params'],
			], [
				'id' => $v['id'],
			]);
		}
	}

	public function down(Schema $schema): void
	{

		$this->addSql('DROP TABLE navigations__navigation_group_text');
		$this->addSql('DROP TABLE navigations__navigation_text');
		$this->addSql(
			'ALTER TABLE navigations__navigation ADD title VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, ADD alias VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, ADD is_published SMALLINT NOT NULL, ADD is_homepage SMALLINT DEFAULT 0 NOT NULL, ADD background VARCHAR(255) DEFAULT NULL COLLATE utf8_unicode_ci, ADD position INT NOT NULL, ADD lang VARCHAR(2) DEFAULT NULL COLLATE utf8_unicode_ci, ADD image VARCHAR(255) DEFAULT NULL COLLATE utf8_unicode_ci, ADD seo LONGTEXT DEFAULT NULL COLLATE utf8_unicode_ci COMMENT \'(DC2Type:array)\', DROP created, CHANGE component_params content_params LONGTEXT DEFAULT NULL COLLATE utf8_unicode_ci COMMENT \'(DC2Type:array)\'',
		);
		$this->addSql('CREATE INDEX lang_idx ON navigations__navigation (lang)');
		$this->addSql(
			'ALTER TABLE navigations__navigation_group ADD title VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci',
		);
	}
}
