<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'navigations__navigation_group')]
#[ORM\Entity]
#[ORM\EntityListeners([NavigationGroupListener::class, TranslateListener::class])]
class NavigationGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var Collection<string, NavigationGroupText>
	 */
	#[ORM\OneToMany(mappedBy: 'navigationGroup', targetEntity: NavigationGroupText::class, indexBy: 'lang')]
	protected Collection $texts;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $type = null;

	public function __construct(string $type)
	{
		$this->type  = $type;
		$this->texts = new ArrayCollection;
	}

	/**
	 * @param NavigationGroupText[] $texts
	 */
	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?NavigationGroupText
	{
		return $this->texts[$lang ?: $this->locale] ?? null;
	}

	/** @return Collection<string, NavigationGroupText> */
	public function getTexts() { return $this->texts; }
}
