<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class NavigationListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache $cache;
	private Cache $baseCache;

	public function __construct(
		protected Storage $cacheStorage,
	)
	{
		$this->cache     = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->baseCache = new Cache($cacheStorage, 'base');
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(Navigation $navigation, PostPersistEventArgs|PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		$this->cache->clean([
			Cache::Tags => [Navigations::CACHE_NAMESPACE],
		]);
		$this->baseCache->clean([
			Cache::Tags => ['navigation'],
		]);
	}

}
