<?php declare(strict_types = 1);

namespace Navigations\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Contributte\Translation\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Helpers\Strings;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Navigations\AdminModule\Model\Navigations as AdminNavigations;
use Navigations\Model\Navigations;

class CurrentNavigation extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'navByGroup';

	public function __construct(
		protected Navigations      $navigations,
		protected AdminNavigations $adminNavigations,
		protected Translator       $translator,
	)
	{
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$list = $this->adminNavigations->getOptionsForSelect();

		if (array_key_exists('site', $params)) {
			foreach ($list as $k => $v) {
				if (!is_numeric($k) && !Strings::startsWith((string) $k, $params['site'])) {
					unset($list[$k]);
				}
			}
		}

		if ($params['multiple'] === 'true') {
			$tmp = [];
			foreach ($list as $group => $values) {
				foreach ($values as $k => $v) {
					$tmp[$k] = $group . ' - ' . $v;
				}
			}

			if ($params['sortable'] ?? false) {
				$formContainer->addSortableCheckboxList($this->getName(), $this->getTitle(), $tmp);
			} else {
				$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $tmp);
			}
		} else {
			$formContainer->addSelect($this->getName(), $this->getTitle(), ['' => ''] + $list);
		}
	}

	/**
	 * @param array $params
	 *
	 * @return DaoNavigationItem|null|DaoNavigationItem[]
	 */
	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		if (is_array($this->getDefault())) {
			$list = [];

			foreach ($this->getDefault() as $k => $v) {
				$nav = $this->navigations->getNavigation((int) $v);
				if ($nav) {
					$list[(int) $v] = $nav;
				}
			}

			return $list;
		}

		return $this->navigations->getNavigation((int) $this->getDefault());
	}

}
