<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="navigations__navigation_group_text")
 * @ORM\Entity
 */
class NavigationGroupText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="NavigationGroup", inversedBy="texts")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public NavigationGroup $navigationGroup;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=true)
	 */
	protected ?string $lang = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $title;

	public function __construct(NavigationGroup $group, string $lang, string $title)
	{
		$this->navigationGroup = $group;
		$this->lang            = $lang;
		$this->title           = $title;
	}

	public function getLang(): string { return $this->lang; }

	public function setLang(?string $lang): self
	{
		$this->lang = $lang === '' ? null : $lang;

		return $this;
	}

}
