<?php declare(strict_types = 1);

namespace Navigations\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Nette\Caching\Storage;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Navigations\Model\Navigations;
use Nette\Caching\Cache;
use Nette\SmartObject;

class NavigationListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache $cache;
	private Cache $baseCache;

	public function __construct(Storage $cacheStorage)
	{
		$this->cache     = new Cache($cacheStorage, Navigations::CACHE_NAMESPACE);
		$this->baseCache = new Cache($cacheStorage, 'base');
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 */
	public function postHandler(Navigation $navigation, LifecycleEventArgs $event): void
	{
		$this->cache->clean([
			Cache::TAGS => [Navigations::CACHE_NAMESPACE],
		]);
		$this->baseCache->clean([
			Cache::TAGS => ['navigation'],
		]);
	}

}
