<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Symfony\Contracts\EventDispatcher\Event;

class RouteInEvent extends Event
{
	public ?DaoNavigationItem $navigation = null;
	public array $urlParams;
	public array $return;
	public bool $disableDefaultFilter = false;

	public function __construct(?DaoNavigationItem $navigation, array &$urlParams, array &$return)
	{
		$this->navigation = $navigation;
		$this->urlParams  = &$urlParams;
		$this->return     = &$return;
	}

}
