<?php declare(strict_types = 1);

namespace Navigations\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Contributte\Translation\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Helpers\Strings;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Navigations\AdminModule\Model\Navigations as AdminNavigations;
use Navigations\Model\Navigations;

class CurrentNavigation extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'navByGroup';

	protected Navigations      $navigationsService;
	protected AdminNavigations $adminNavigations;
	protected Translator       $translator;

	public function __construct(
		Navigations      $navigations,
		AdminNavigations $adminNavigations,
		Translator       $translator
	)
	{
		$this->navigationsService = $navigations;
		$this->adminNavigations   = $adminNavigations;
		$this->translator         = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$list = $this->adminNavigations->getOptionsForSelect();
		if (array_key_exists('site', $params)) {
			foreach ($list as $k => $v) {
				if (!is_numeric($k) && !Strings::startsWith((string) $k, $params['site'])) {
					unset($list[$k]);
				}
			}
		}

		if ($params['multiple'] === 'true') {
			foreach ($list as $g => $vals) {
				foreach ($vals as $k => $v) {
					$list[$g][$k] = $g . ' - ' . $v;
				}
			}
			$formContainer->addCheckboxList($this->getName(), $this->getTitle(), $list);
		} else {
			$formContainer->addSelect($this->getName(), $this->getTitle(), ['' => ''] + $list);
		}
	}

	/**
	 * @param array $params
	 *
	 * @return DaoNavigationItem|null|DaoNavigationItem[]
	 */
	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		if ($params['multiple'] === 'true') {
			$navs = [];
			foreach ($this->getDefault() ?? [] as $id) {
				$nav = $this->navigationsService->getNavigation((int) $id);

				if ($nav) {
					$navs[$id] = $nav;
				}
			}

			return $navs;
		}

		return $this->navigationsService->getNavigation((int) $this->getDefault());
	}

}
