<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Presenters;

use Core\AdminModule\Presenters\SecuredPresenter;
use Nette\Application\BadRequestException;

abstract class BasePresenter extends SecuredPresenter
{
	/**
	 * @param mixed $element
	 *
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}
}
