<?php declare(strict_types = 1);

namespace Navigations\DI;

use Core\DI\CompilerExtension;
use Navigations\Model\Providers\INavigationItem;
use Nette;

class NavigationsExtension extends CompilerExtension
{
	/** @var string[] */
	protected array $navigationItems = [];

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Navigations' => 'Navigations\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var Nette\DI\Definitions\ServiceDefinition $service */
		$service = $builder->getDefinition('navigations.itemsCollector');
		$service->addSetup('loadClasses', [$builder->findByType(INavigationItem::class)]);

		foreach ($builder->findByType(INavigationItem::class) as $k => $service) {
			$this->navigationItems[] = $k;
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->getMethod('initialize');

		$init->addBody('$translatorService = $this->getService(\'translation.translator\');');
		$init->addBody('$this->getService(\'navigations.navigations\')->translator = $translatorService;');

		foreach ($this->navigationItems as $item) {
			$init->addBody('$this->getService(\'' . $item . '\')->setTranslator($translatorService);');
		}

		$init->addBody('Navigations\Model\NavigationConfig::setParams($this->parameters[\'navigations\']);');
	}

}
