<?php declare(strict_types = 1);

namespace Navigations\FrontModule\Model;

use Contributte\Translation\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Lang\Langs;
use Core\Model\Sites;
use Navigations\Model\Navigations;

class LinksHelper
{
	protected ?array $cLinks = null;

	public function __construct(
		protected Sites       $sites,
		protected Navigations $navigations,
		protected Translator  $translator,
		protected Langs       $langs,
	)
	{
	}

	/**
	 * @param DaoNavigationItem|object $currentNav
	 */
	public function getOtherLangLinks($currentNav, array $currentParams, string $presenterName): array
	{
		if ($currentNav instanceof DaoNavigationItem === false) {
			return [];
		}

		if ($this->cLinks !== null) {
			return $this->cLinks;
		}

		$this->cLinks = [];
		$currentSite  = $this->sites->getCurrentSite();
		$defaultLang  = $this->translator->getDefaultLocale();
		$currentLang  = $this->translator->getLocale();

		foreach ($this->translator->getLocalesWhitelist() as $lang) {
			$this->translator->setLocale($lang);
			$siteDomain = $currentSite->getDomains()[$lang] ?? null;
			$domain     = $siteDomain && $siteDomain->getDomain() ? $siteDomain->getDomain() : null;
			$langData   = $this->langs->getLang($lang);

			if (!$domain) {
				continue;
			}

			$nav                        = $this->navigations->getNavigation($currentNav->id, $lang);
			$params                     = $currentParams;
			$params['activeNavigation'] = $nav;
			$params['presenter']        = $presenterName;
			$params['locale']           = $lang;
			$params['domain']           = $domain;

			$link = $nav
				? $this->navigations->getUrlById($params)
				: 'https://' . $domain . '/' . ($siteDomain->isDefault == 0 && $lang !== $defaultLang ? $lang : '');

			$this->cLinks[$lang] = [
				'title'      => $langData->getTitle(),
				'shortTitle' => $langData->getShortTitle(),
				'link'       => $link,
				'isActive'   => $currentLang === $lang,
				'navigation' => $nav,
			];
		}
		$this->translator->setLocale($currentLang);

		return $this->cLinks;
	}
}
