<?php declare(strict_types = 1);

namespace Navigations\Model;

use Contributte\Translation\Exceptions\InvalidArgument;
use Contributte\Translation\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Event\EventDispatcher;
use Navigations\AdminModule\Components\NavigationForm;

abstract class BaseItem
{
	/** @var string */
	protected $id;

	/** @var string */
	protected $title;

	/** @var string */
	protected $langBase;

	/** @var string */
	protected $presenter;

	/** @var string */
	protected $action;

	/** @var Translator @inject */
	public $translator;

	/** @var EventDispatcher @inject */
	public $eventDispatcher;

	/**
	 * @param int|null    $count
	 * @param string[]    $parameters
	 * @param string|null $domain
	 * @param string|null $locale
	 *
	 * @throws InvalidArgument
	 */
	protected function t(string $message, $count = null, $parameters = [], $domain = null, $locale = null): string
	{
		return $this->translator->translate($message, $count, $parameters, $domain, $locale);
	}

	/**
	 * @return string
	 */
	public function getGroup()
	{
		return explode('\\', static::class)[0];
	}

	public function getGroupTitle(): string
	{
		return $this->langBase . '.groupTitle';
	}

	public function getTitle(): string
	{
		return $this->langBase . '.' . $this->title;
	}

	public function getClassString(): string
	{
		return static::class;
	}

	/**
	 * @param string $id
	 */
	public function setId($id): void
	{
		$this->id = $id;
	}

	public function getId(): string { return $this->id; }

	public function setTranslator(Translator $translator): void
	{
		$this->translator = $translator;
	}

	/**
	 * @param array $urlParams
	 *
	 * @return void
	 */
	public function updateCacheDep(array &$cache, $urlParams) { }

	public function getTemplateFile(): ?string { return null; }

	public function navigationFormCustomHandle(NavigationForm $component, array $data = []): void { return; }

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function getPresenter(): string { return $this->presenter; }

	public function getAction(): string { return $this->action; }

	/**
	 * @param DaoNavigationItem|null $navigation
	 * @param bool                   $siteMapData
	 *
	 * @return array
	 */
	public function getComponentChild(string $lang, $navigation = null, $siteMapData = false) { return []; }

	/**
	 * @param array $urlParams
	 */
	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return null;
	}
}
