<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Symfony\Contracts\EventDispatcher\Event;

class RouteInEvent extends Event
{
	public array $urlParams;
	public array $return;
	public bool  $disableDefaultFilter = false;

	public function __construct(
		public ?DaoNavigationItem $navigation,
		array                     &$urlParams,
		array                     &$return,
	)
	{
		$this->urlParams = &$urlParams;
		$this->return    = &$return;
	}

}
