<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Symfony\Contracts\EventDispatcher\Event;

class RouteOutEvent extends Event
{
	public array   $urlParams;
	public ?string $url                  = null;
	public bool    $disableDefaultFilter = false;

	public function __construct(
		array                     &$urlParams,
		public ?DaoNavigationItem $navigation = null,
		?string                   &$url = null,
	)
	{
		$this->urlParams = &$urlParams;
		$this->url       = &$url;
	}

}
