<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Helpers\BaseService;
use Navigations\Model\Providers\INavigationItem;

class ItemsCollector extends BaseService
{
	/** @var INavigationItem[] */
	private array   $itemsList = [];
	protected array $items     = [];

	public function getItemById(string $id): ?INavigationItem
	{
		return $this->itemsList[$id] ?? null;
	}

	public function getItems(): array
	{
		return $this->items;
	}

	public function findItemByPresenter(string $presenter, string $action): array
	{
		$items = [];
		foreach ($this->itemsList as $item) {
			$r = $item->presenterActionCheck($presenter, $action);
			if ($r) {
				$items[$r][] = $item;
			}
		}

		return $items;
	}

	/**
	 * Voláno při generování containeru
	 */
	public function loadClasses(array $items): void
	{
		foreach ($items as $key => $item) {
			/** @var $item BaseItem */
			$item->getGroup();
			$item->setId($key);

			$this->itemsList[$key] = $item;
			$arr                   = &$this->items[$item->getGroup()];

			if (!isset($arr)) {
				$arr = ['title' => $item->getGroupTitle(), 'items' => []];
			}

			$arr['items'][] = $item;
		}
	}

}
