<?php declare(strict_types = 1);

namespace Navigations\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;
use Nette\Routing\Route as RouteAlias;
use function str_starts_with;

class RouterFrontFactory
{
	public function __construct(public Navigations $navigationsService, protected RouteHelper $routerHelper)
	{
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$router[] = $this->routerHelper->createRoute('/<path .*>', [
			null => [
				RouteAlias::FILTER_IN  => function($params) {
					if (!isset($params['path'])) {
						return null;
					}

					if (isset($params['locale']) && $params['locale'] === 'cz') {
						$params['locale'] = 'cs';
					}

					$in = $this->navigationsService->getIdByUrl($params);

					if ($in && is_array($in)) {
						if (is_array($params)) {
							$params = $params + $in;
						}
						unset($params['path']);

						return $params;
					}

					return null;
				},
				RouteAlias::FILTER_OUT => function($params) {
					$out = $this->navigationsService->getUrlById($params);

					if ($out) {
						$params['path'] = ltrim($out, '/');
					} else {
						return null;
					}

					unset($params['id'], $params['locale'], $params['action'], $params['presenter'], $params['activeNavigation']);

					// kvuli eshop filtru
					if ((isset($params['productsFilter-filter']['f'][''])
							|| empty($params['productsFilter-filter']))
						&& isset($params['do']) && str_starts_with((string) $params['do'], 'productsFilter')) {
						unset($params['do']);
					}

					return $params;
				},
			],
		]);

		$router[] = $this->routerHelper->createRoute('/[<locale [a-z]{2}>/]', [
			null => [
				RouteAlias::FILTER_IN  => function($params) {
					if (isset($params['locale']) && $params['locale'] === 'cz') {
						$params['locale'] = 'cs';
					}

					unset($params['activeNavigation'], $params['id']);

					$hp = $this->navigationsService->getHomepageForRouter($params['locale']);

					if ($hp) {
						return $params + $hp;
					}

					return $params;
				},
				RouteAlias::FILTER_OUT => function($params) {
					unset($params['id'], $params['action'], $params['presenter'], $params['activeNavigation']);

					return $params;
				},
			],
		]);

		return $router;
	}

}
