<?php declare(strict_types = 1);

namespace Navigations\Model\Templating\Filters;

use Navigations\Model\Navigations;
use Nette\Utils\Json;

class NavLink
{
	public function __construct(protected Navigations $navigationsService)
	{
	}

	public function __invoke(int $id): ?string
	{
		$nav = $this->navigationsService->getNavigation($id);

		if (!$nav) {
			return '';
		}

		if (is_array($nav->link)) {
			return Json::encode($nav->link);
		}

		return $nav->link;
	}
}
