<?php declare(strict_types = 1);

namespace Navigations\Model\Templating\Macros;

use Latte;
use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;
use Navigations\Model\Navigations;

final class NavLink extends MacroSet
{
	public function __construct(
		Latte\Compiler        $compiler,
		protected Navigations $navigationsService,
	)
	{
		parent::__construct($compiler);
	}

	public static function install(Compiler $compiler, Navigations $navigations): void
	{
		$self = new self($compiler, $navigations);
		$self->addMacro('navLink', $self->macroNavLink(...));
	}

	public function macroNavLink(MacroNode $node, PhpWriter $writer): string
	{
		$str = '';
		$nav = $this->navigationsService->getNavigation((int) $node->args);

		if ($nav) {
			$link = is_array($nav->link) ? $nav->link[0] : $nav->link;
			$str  = "echo '" . $link . "'";
		}

		return $writer->write($str);
	}
}
