<?php declare(strict_types = 1);

namespace Navigations\AdminModule\Model;

use Core\Model\Exceptions\EntityContainChildren;
use Core\Model\Helpers\BaseEntityService;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Entities\NavigationGroup;

/**
 * @method NavigationGroup getReference($id)
 * @method NavigationGroup|null get($id)
 */
class NavigationsGroups extends BaseEntityService
{
	/** @var string */
	protected $entityClass = NavigationGroup::class;

	/**
	 * @return NavigationGroup[]
	 */
	public function getAll(): array
	{
		return $this->getEr()->createQueryBuilder('g')->addSelect('gt')
			->join('g.texts', 'gt')
			->getQuery()->getResult();
	}

	/**
	 * @param int|string $id
	 *
	 * @throws EntityContainChildren
	 */
	public function remove($id): bool
	{
		$group = $this->get($id);

		if ($group) {
			$navs = $this->em->getRepository(Navigation::class)->findBy(['group' => $id]);

			if (count($navs) > 1) {
				throw new EntityContainChildren('navigations.navigationGroup.removeFailedHasNavs');
			}

			if (count($navs) === 1) {
				$this->em->remove(array_values($navs)[0]);
			}

			$this->em->remove($group);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
