<?php declare(strict_types = 1);

namespace Navigations\FrontModule\Components;

use Core\FrontModule\Presenters\BasePresenter;
use Core\Model\Parameters;
use Core\Model\UI\BaseControl;
use Navigations\FrontModule\Model\LinksHelper;
use ReflectionException;

/**
 * @method BasePresenter getPresenter($throw = true)
 */
class HrefLang extends BaseControl
{
	protected LinksHelper $linksHelper;

	public function __construct(LinksHelper $linksHelper)
	{
		$this->linksHelper = $linksHelper;
	}

	/**
	 * @param array $args
	 * @throws ReflectionException
	 */
	public function render($args = []): void
	{
		$links = $this->getLinks();

		$this->template->renderArgs  = $args;
		$this->template->defaultLink = $links[$this->translator->getDefaultLocale()];
		$this->template->links       = $links;
		$this->template->activeLang  = $links[$this->translator->getLocale()];
		$this->template->render($this->getTemplateFile());
	}

	public function getLinks(): array
	{
		$presenter = $this->getPresenter();
		$links     = $this->linksHelper->getOtherLangLinks($presenter->getActiveNavigation(), $presenter->getParameters(), $presenter->getName());

		$langKeys = Parameters::load('replaceLangKey');
		foreach ($langKeys as $k => $v) {
			if (!isset($links[$k])) {
				continue;
			}

			$links[$v] = $links[$k];
			unset($links[$k]);
		}

		return $links;
	}
}
