<?php declare(strict_types = 1);

namespace Navigations\Model\Event;

use Core\Components\Navigation\DaoNavigationItem;
use Symfony\Contracts\EventDispatcher\Event;

class RouteOutEvent extends Event
{
	public ?DaoNavigationItem $navigation = null;
	public array $urlParams;
	public ?string $url = null;
	public bool $disableDefaultFilter = false;

	public function __construct(?DaoNavigationItem $navigation = null, array &$urlParams, ?string &$url = null)
	{
		$this->navigation = $navigation;
		$this->urlParams  = &$urlParams;
		$this->url        = &$url;
	}

}
