<?php declare(strict_types = 1);

namespace Navigations\Model\Providers;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\AdminModule\Components\NavigationForm;
use Nette\Utils\ArrayHash;

interface INavigationItem
{
	/**
	 * @return string
	 */
	public function getId();

	/**
	 * @return string
	 */
	public function getGroup();

	/**
	 * @return string
	 */
	public function getGroupTitle();

	/**
	 * @return string
	 */
	public function getTitle();

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $form);

	/**
	 * @return void
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values);

	public function getTemplateFile(): ?string;

	public function navigationFormCustomHandle(NavigationForm $component, array $data = []): void;

	/**
	 * @param array $cache
	 * @param array $urlParams
	 * @return void
	 */
	public function updateCacheDep(array &$cache, $urlParams);

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	/**
	 * @param string $presenter
	 * @param string $action
	 *
	 * @return int|bool
	 */
	public function presenterActionCheck($presenter, $action);

	/**
	 * @return string
	 */
	public function getPresenter();

	/**
	 * @return string
	 */
	public function getAction();

	/**
	 * @param DaoNavigationItem $navigation
	 * @param array             $urlParams
	 *
	 * @return mixed
	 */
	public function routerIn($navigation, $urlParams = []);

	/**
	 * @param array $urlParams
	 */
	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string;

	/**
	 * @param DaoNavigationItem|null $navigation
	 * @param bool                   $siteMapData
	 *
	 * @return array
	 */
	public function getComponentChild(string $lang, $navigation = null, $siteMapData = false);
}
