<?php declare(strict_types = 1);

namespace Navigations\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Contributte\Translation\Translator;
use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\BaseContainer;
use Doctrine\ORM\Query\Expr\Join;
use Navigations\Model\Navigations;

class CurrentNavigation extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'navByGroup';
	protected Navigations $navigationsService;
	protected Translator $translator;

	public function __construct(Navigations $navigations, Translator $translator)
	{
		$this->navigationsService = $navigations;
		$this->translator         = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$groups = [null => ''];

		foreach ($this->navigationsService
			         ->getEr()->createQueryBuilder('n')
			         ->select('n.id, nt.title, n.lvl, ngt.title as groupTitle')
			         ->innerJoin('n.texts', 'nt', Join::WITH, 'nt.lang = :lang')
			         ->innerJoin('n.group', 'ng')
			         ->innerJoin('ng.texts', 'ngt', Join::WITH, 'ngt.lang = :lang')
			         ->setParameter('lang', $this->translator->getLocale())
			         ->orderBy('n.root')->addOrderBy('n.lft')
			         ->getQuery()->getResult() as $v) {
			$title = ' ' . $v['title'];
			for ($i = 1; $i < $v['lvl']; $i++) {
				$title = '---' . $title;
			}
			$groups[$v['groupTitle']][$v['id']] = trim($title);
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $groups);
	}

	/**
	 * @param array $params
	 * @return DaoNavigationItem|null
	 */
	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->navigationsService->getNavigation((int) $this->getDefault());
	}

}
