<?php declare(strict_types = 1);

namespace Navigations\Model\Templating\Filters;

use Navigations\Model\Navigations;

class NavLink
{
	protected Navigations $navigationsService;

	public function __construct(Navigations $navigations)
	{
		$this->navigationsService = $navigations;
	}

	public function __invoke(int $id): ?string
	{
		$nav = $this->navigationsService->getNavigation($id);

		return $nav ? $this->navigationsService->generateLink($nav) : '';
	}
}
