<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Core\Model\TemplateReader\TemplateReaderControl;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Pages\Model\Entities\TemplateBlock;
use Pages\Model\TemplateBlocks;

class TemplateBlockForm extends TemplateReaderControl
{
	/** @var TemplateBlock */
	protected $entity;

	/** @var TemplateBlocks */
	protected $templateBlocksService;

	public function __construct(TemplateBlocks $templateBlocks)
	{
		$this->templateBlocksService = $templateBlocks;
	}

	public function render()
	{
		$this->template->componentStructure = $this->templateReader->getComponentStructure();
		$this->template->thisForm           = $this['form'];

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm()
	{
		$this->templateReader->setTemplatesDir($this->templateBlocksService->getTemplatesDir());
		$this->templateReader->setTranslateKey('templateBlock');

		$form = $this->createForm();

		$templates = $this->templateReader->getTemplates();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSelect('template', 'default.templates', $templates)->setPrompt('default.choose')->setRequired();
		$form->addComponent(new BaseContainer(), 'component');

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$entity = $this->entity ?: new TemplateBlock($values->title, $values->template);

			$entity->title       = $values->title;
			$entity->isPublished = $values->isPublished;
			$entity->template    = $values->template;
			$entity->setTexts($form->getComponent('component')->getValues(true));

			$flashMessage = $entity->getId() ? 'pages.templateForm.edited' : 'pages.templateForm.added';

			$this->em->persist($entity)->flush();
			$form->addCustomData('templateBlockId', $entity->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	public function setBlock($id)
	{
		$this->entity = $this->templateBlocksService->get($id);

		if ($this->entity) {
			$form = $this['form'];
			$form->setDefaults([
				'title'       => $this->entity->title,
				'isPublished' => $this->entity->isPublished,
			]);

			if ($this->entity->template && array_key_exists($this->entity->template, $form['template']->getItems())) {
				$form['template']->setDefaultValue($this->entity->template);

				if ($this->httpRequest->getQuery('do') != 'templateBlockForm-loadInputs') {
					$this->templateReader->loadTemplateComponents($this['form']['component'], $this->httpRequest->getPost('template') ?: $this->entity->template);
					$this->templateReader->setDefaults($this['form']['component'], $this->entity);
				}
			}
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
