<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Core\Model\TemplateReader\TemplateReaderControl;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Nette\Application\UI\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Pages\Model\Entities\TemplatePage;
use Pages\Model\TemplatePages;

class TemplatePageForm extends TemplateReaderControl
{
	/** @var TemplatePage */
	protected $entity;

	/** @var TemplatePages */
	protected $templatePagesService;

	public function __construct(TemplatePages $templatePages)
	{
		$this->templatePagesService = $templatePages;
	}

	public function render()
	{
		$this->template->componentStructure = $this->templateReader->getComponentStructure();
		$this->template->thisForm           = $this['form'];

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm()
	{
		$this->templateReader->setTemplatesDir($this->templatePagesService->getTemplatesDir());
		$this->templateReader->setTranslateKey('templatePage');

		$form = $this->createForm();

		$templates = $this->templateReader->getTemplates();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addSelect('template', 'default.templates', $templates)->setPrompt('default.choose')->setRequired();
		$form->addComponent(new BaseContainer(), 'component');

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$entity = $this->entity ?: new TemplatePage($values->title, $values->template);

			$entity->title       = $values->title;
			$entity->isPublished = $values->isPublished;
			$entity->template    = $values->template;
			$entity->setTexts($form->getComponent('component')->getValues(true));

			$flashMessage = $entity->getId() ? 'pages.templateForm.edited' : 'pages.templateForm.added';

			$this->em->persist($entity)->flush();
			$form->addCustomData('templatePageId', $entity->getId());
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	public function setPage($id)
	{
		$this->entity = $this->templatePagesService->get($id);

		if ($this->entity) {
			$form = $this['form'];
			$form->setDefaults([
				'title'       => $this->entity->title,
				'isPublished' => $this->entity->isPublished,
			]);

			if ($this->entity->template && array_key_exists($this->entity->template, $form['template']->getItems())) {
				$form['template']->setDefaultValue($this->entity->template);

				if ($this->httpRequest->getQuery('do') != 'templatePageForm-loadInputs') {
					$this->templateReader->loadTemplateComponents($this['form']['component'], $this->httpRequest->getPost('template') ?: $this->entity->template);
					$this->templateReader->setDefaults($this['form']['component'], $this->entity);
				}
			}
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
