<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Pages\Model\TemplatePages;

class TemplatePagesGrid extends BaseControl
{
	/** @var TemplatePages */
	protected $templatePagesService;

	public function __construct(TemplatePages $templatePages)
	{
		$this->templatePagesService = $templatePages;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->templatePagesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->templatePagesService->getEr()->createQueryBuilder('p');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'TemplatePages:edit');

		// Filter
		$grid->addFilterText('title', 'default.title');

		// Actions
		$grid->addAction('edit', '', 'TemplatePages:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setConfirm('default.reallyDelete')->setBsType('danger')->addClass('ajax');

		return $grid;
	}
}
