<?php declare(strict_types = 1);

namespace Pages\DI;

use Core\DI\CompilerExtension;
use Nette;

class PagesExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions(
			$this->getContainerBuilder(),
			$this->loadFromFile(__DIR__ . '/services.neon')
		);
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Pages' => 'Pages\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$builder->getDefinition('nette.latteFactory')
			->addSetup('addFilter', ['templateBlock', $builder->getDefinition('pages.filters.templateBlock')]);
	}
}