<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplateBlock;

/**
 * Class TemplateBlocks
 * @package Pages\FrontModule\Model
 *
 * @method TemplateBlock|object|null getReference($id)
 * @method TemplateBlock[]|null getAll()
 */
class TemplateBlocks extends BaseEntityService
{
	protected $entityClass = TemplateBlock::class;

	public function get($id)
	{
		$query = $this->getEr()->createQueryBuilder('b', 'b.id')->where('b.isPublished = 1')
			->andWhere(is_array($id) ? 'b.id IN (:id)' : 'b.id = :id')->setParameter('id', $id)->getQuery();

		return is_array($id) ? $query->getResult() : $query->getOneOrNullResult();
	}

	/**
	 * @return TemplateBlock[]
	 */
	public function getPublished()
	{
		return $this->getEr()->createQueryBuilder('b', 'b.id')->where('b.isPublished = 1')->getQuery()->getResult();
	}
}