<?php declare(strict_types = 1);

namespace Pages\FrontModule\Presenters;

use Pages\Model\Pages;
use Pages\Model\TemplatePages;

class DefaultPresenter extends BasePresenter
{
	/** @var Pages */
	protected $pagesService;

	/** @var TemplatePages */
	protected $templatePagesService;

	public function __construct(Pages $pages, TemplatePages $templatePages)
	{
		$this->pagesService         = $pages;
		$this->templatePagesService = $templatePages;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPage($id)
	{
		$page = $this->pagesService->get($id);

		if (!$page || !$page->isPublished)
			$this->error('pages.page.notFound');

		$this->template->pageClass .= ' one-page';
		$this->template->page = $page;
	}

	public function actionTemplatePage($id)
	{
		$id   = $id ?: $this->getActiveNavigation()->componentParams['templatePage'];
		$page = $this->templatePagesService->get($id);

		if (!$page || !$page->isPublished)
			$this->error('pages.page.notFound');

		$this->template->templateTextValues = $page->getTexts();
		$this->template->setFile($this->templatePagesService->getTemplateFile($page->template));
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
}