<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\TemplateReader\Entity\TTemplate;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="pages__template_page")
 * @ORM\Entity
 */
class TemplatePage implements ITemplate
{
	use Identifier;
	use MagicAccessors;
	use TTemplate;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=false)
	 */
	public $isPublished;

	/**
	 * TemplatePage constructor.
	 *
	 * @param $title
	 * @param $template
	 */
	public function __construct($title, $template)
	{
		$this->title       = $title;
		$this->template    = $template;
		$this->isPublished = 1;
		$this->texts       = [];
	}
}