<?php declare(strict_types = 1);

namespace Pages\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplateBlock;

/**
 * Class TemplateBlocks
 * @package Pages\Model
 *
 * @method TemplateBlock|object|null getReference($id)
 * @method TemplateBlock[]|null getAll()
 * @method TemplateBlock|null get($id)
 */
class TemplateBlocks extends BaseEntityService
{
	protected $entityClass = TemplateBlock::class;

	/**
	 * TODO static
	 *
	 * @return string
	 */
	public function getTemplatesDir() { return TEMPLATES_DIR . '/Front/default/Pages/TemplateBlocks'; }

	/**
	 * TODO static
	 *
	 * @param string $name
	 *
	 * @return string
	 */
	public function getTemplateFile($name) { return $this->getTemplatesDir() . '/' . $name; }
}