<?php declare(strict_types = 1);

namespace Pages\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplatePage;

/**
 * Class TemplatePages
 * @package Pages\Model
 *
 * @method TemplatePage|object|null getReference($id)
 * @method TemplatePage[]|null getAll()
 * @method TemplatePage|null get($id)
 */
class TemplatePages extends BaseEntityService
{
	protected $entityClass = TemplatePage::class;

	/**
	 * @return string
	 */
	public function getTemplatesDir() { return TEMPLATES_DIR . '/Front/default/Pages/TemplatePages'; }

	/**
	 * @param string $name
	 *
	 * @return string
	 */
	public function getTemplateFile($name) { return $this->getTemplatesDir() . '/' . $name; }
}