<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Nette\Application\UI\ITemplateFactory;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\Model\TemplateBlocks;

class Block extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'block';

	/** @var TemplateBlocks */
	protected $templateBlocksService;

	/** @var @var ITemplateFactory */
	protected $templateFactory;

	/**
	 * Block constructor.
	 *
	 * @param TemplateBlocks   $templateBlocksService
	 * @param ITemplateFactory $templateFactory
	 */
	public function __construct(TemplateBlocks $templateBlocksService, ITemplateFactory $templateFactory)
	{
		$this->templateBlocksService = $templateBlocksService;
		$this->templateFactory       = $templateFactory;
	}

	public function loadContainer($formContainer, $params = [])
	{
		$blocks    = ['' => ''];
		$allBlocks = $this->templateBlocksService->getEr()->findBy([], ['title' => 'ASC']);
		foreach ($allBlocks as $b) {
			$blocks[$b->getId()] = $b->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $blocks);
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params)
	{
		$block = $this->templateBlocksService->getEr()->createQueryBuilder('b')->where('b.id = :id')->andWhere('b.isPublished = 1')
			->setParameter('id', $this->getDefault())->getQuery()->getOneOrNullResult();

		if (!$block)
			return '';

		// TODO přesunout do služby
		$template                  = $block->template;
		$latte                     = $this->templateFactory->createTemplate();
		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->templateBlocksService->getTemplateFile($template));
		$content = $latte->renderToString();

		return $content;
	}
}