<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Nette\Application\UI\ITemplateFactory;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\Model\TemplateBlocks;

class Blocks extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'blocks';

	/** @var TemplateBlocks */
	protected $templateBlocksService;

	/** @var @var ITemplateFactory */
	protected $templateFactory;

	/**
	 * Block constructor.
	 *
	 * @param TemplateBlocks   $templateBlocksService
	 * @param ITemplateFactory $templateFactory
	 */
	public function __construct(TemplateBlocks $templateBlocksService, ITemplateFactory $templateFactory)
	{
		$this->templateBlocksService = $templateBlocksService;
		$this->templateFactory       = $templateFactory;
	}

	public function loadContainer($formContainer, $params = [])
	{
		$items = [];
		foreach ($this->templateBlocksService->getEr()->createQueryBuilder('b')->select('b.id, b.title')->where('b.isPublished = 1')
			         ->orderBy('b.title')->getQuery()->getArrayResult() as $b) {
			$items[$b['id']] = $b['title'];
		}

		$formContainer->addSortableCheckboxList($this->getName(), $this->getTitle(), $items);
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params)
	{
		$content = '';
		$blocks  = $this->templateBlocksService->getEr()->createQueryBuilder('b', 'b.id')->where('b.id IN (:id)')->andWhere('b.isPublished = 1')
			->setParameter('id', $this->getDefault())->getQuery()->getResult();

		foreach ($this->getDefault() as $id) {
			$block = $blocks[$id] ?? null;

			if (!$block)
				continue;

			// TODO přesunout do služby
			$template                  = $block->template;
			$latte                     = $this->templateFactory->createTemplate();
			$latte->templateTextValues = $block->getTexts();
			$latte->setFile($this->templateBlocksService->getTemplateFile($template));
			$content .= $latte->renderToString();
		}

		return $content;
	}
}