<?php declare(strict_types = 1);

namespace Pages\Model\Templating\Filters;

use Nette\Utils\Html;
use Pages\FrontModule\Model\TemplateBlocks as FrontTemplateBlocks;
use Pages\Model\TemplateBlocks;
use Nette\Application\UI\ITemplateFactory;

class TemplateBlock
{
	/** @var TemplateBlocks */
	protected $templateBlocks;

	/** @var FrontTemplateBlocks */
	protected $frontTemplateBlocks;

	/** @var ITemplateFactory */
	protected $templateFactory;

	/**
	 * TODO odstranit TemplateBlock $tempalteBLock po předělání getTemplateFile na static
	 *
	 * TemplateBlock constructor.
	 *
	 * @param FrontTemplateBlocks $frontTemplateBlocks
	 * @param TemplateBlocks      $templateBlocks
	 * @param ITemplateFactory    $templateFactory
	 */
	public function __construct(FrontTemplateBlocks $frontTemplateBlocks, TemplateBlocks $templateBlocks, ITemplateFactory $templateFactory)
	{
		$this->frontTemplateBlocks = $frontTemplateBlocks;
		$this->templateBlocks      = $templateBlocks;
		$this->templateFactory     = $templateFactory;
	}

	public function __invoke($id)
	{
		$args  = func_get_args();
		$block = $this->frontTemplateBlocks->get($id);

		if (!$block)
			return '';

		// TODO přesunout do služby
		$template = $block->template;
		$latte    = $this->templateFactory->createTemplate();

		if (isset($args[1]))
			$latte->presenter = $args[1];
		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->templateBlocks->getTemplateFile($template));

		return (new Html())->setHtml($latte->renderToString());
	}
}