<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Blog\Model\UI;
use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Pages\Model\Entities\Page;
use Pages\Model\Pages;

class PageForm extends BaseControl
{
	/** @var Page */
	public $page;

	/** @var Pages */
	protected $pagesService;

	public function __construct(Pages $pages)
	{
		$this->pagesService = $pages;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addEditor('text', 'default.content');

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			$page = $this->page ?: new Page($values->title, $values->isPublished);

			$page->title       = $values->title;
			$page->isPublished = $values->isPublished;
			$page->text        = $values->text;

			$flashMessage = $page->getId() ? 'pages.pageForm.edited' : 'pages.pageForm.added';

			$this->em->persist($page)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setPage($id)
	{
		$this->page = $this->pagesService->get($id);

		if ($this->page) {
			$this['form']->setDefaults([
				'title'       => $this->page->title,
				'isPublished' => $this->page->isPublished,
				'text'        => $this->page->text,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
