<?php declare(strict_types = 1);

namespace Pages\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Nette\Application\ForbiddenRequestException;
use Nette\Http\IResponse;
use Pages\AdminModule\Components\ITemplatePageFormFactory;
use Pages\AdminModule\Components\ITemplatePagesGridFactory;
use Pages\Model\Entities\TemplatePage;

class TemplatePagesPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('pages.title.templatePages'));
		$this->setHeader('pages.title.templatePages', 'fa fa-file-image');
	}

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'accessTemplatePages')) {
			throw new ForbiddenRequestException();
		}
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'pages.menu.newTemplatePage',
				'link'  => 'TemplatePages:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('pages.title.newTemplatePage'));
		$this->setHeader('pages.title.newTemplatePage', 'fa fa-file-image');
	}

	public function actionEdit($id)
	{
		$page = $this->em->getRepository(TemplatePage::class)->find($id);

		if (!$page)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('pages.title.editTemplatePage'), $page->title);
		$this->setHeader('pages.title.editTemplatePage', 'fa fa-file-image');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentTemplatePagesGrid(ITemplatePagesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentTemplatePageForm(ITemplatePageFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setPage($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('templatePageId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}
}