<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Caching\Cache;
use Pages\Model\Entities\TemplateBlock;

/**
 * Class TemplateBlocks
 * @package Pages\FrontModule\Model
 */
class TemplateBlocks extends BaseFrontEntityService
{
	const CACHE_NAMESPACE = 'templateBlocks';

	protected $entityClass = TemplateBlock::class;

	/** @var array */
	protected $cacheDep = [
		Cache::TAGS    => [self::CACHE_NAMESPACE],
		Cache::EXPIRE  => '1 week',
		Cache::SLIDING => true,
	];

	public function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function get($id)
	{
		$key = self::CACHE_NAMESPACE . '/' . serialize($id);

		return $this->getCache()->load($key, function(&$dep) use ($id) {
			$dep = $this->cacheDep;

			$query = $this->getEr()->createQueryBuilder('b', 'b.id')->where('b.isPublished = 1')
				->andWhere(is_array($id) ? 'b.id IN (:id)' : 'b.id = :id')->setParameter('id', $id)->getQuery();

			return is_array($id) ? $query->getResult() : $query->getOneOrNullResult();
		});
	}

	/**
	 * @return TemplateBlock[]
	 */
	public function getPublished()
	{
		$key = self::CACHE_NAMESPACE . '/published';

		return $this->getCache()->load($key, function(&$dep) {
			$dep = $this->cacheDep;

			return $this->getEr()->createQueryBuilder('b', 'b.id')->where('b.isPublished = 1')->getQuery()->getResult();
		});
	}
}
