<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;
use Pages\FrontModule\Model\TemplatePages;

class TemplatePageListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session = $session;
		$this->cache   = new Cache($cacheStorage, TemplatePages::CACHE_NAMESPACE);
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param TemplatePage       $templatePage
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler(TemplatePage $templatePage, LifecycleEventArgs $event)
	{
		$this->cache->clean([
			Cache::TAGS => [TemplatePages::CACHE_NAMESPACE],
		]);
	}
}
