<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Text extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'text';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$formContainer->addText($this->getName(), $this->getTitle());
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}