<?php declare(strict_types = 1);

namespace Pages\AdminModule\Presenters;

use Nette\Application\ForbiddenRequestException;
use Nette\Http\IResponse;
use Nette\Utils\Html;
use Pages\AdminModule\Components\IPageFormFactory;
use Pages\AdminModule\Components\IPagesGridFactory;
use Pages\Model\Entities\Page;

class PagesPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('pages.title.pages'));
		$this->setHeader('pages.title.pages', 'fa-file');
	}

	public function checkRequirements($element)
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'accessPages')) {
			throw new ForbiddenRequestException();
		}
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'pages.menu.newPage',
				'link'  => 'Pages:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('pages.title.newPage'));
		$this->setHeader('pages.title.newPage', 'fa-file');
	}

	public function actionEdit($id)
	{
		$page = $this->em->getRepository(Page::class)->find($id);

		if (!$page)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('pages.title.editPage'), $page->title);
		$this->setHeader('pages.title.editPage', 'fa-file');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentPagesGrid(IPagesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentPageForm(IPageFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setPage($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function () {
			$this->redirect('default');
		};

		return $control;
	}
}